// Initialize the map and set its view to a chosen geographical coordinates and zoom level
var map = L.map('map').setView([-1.2382688, 36.9123459], 13);

// Set up the OpenStreetMap tiles using Leaflet
L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
    maxZoom: 19,
    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
}).addTo(map);

// Add a marker on the map at the given coordinates
var marker = L.marker([-1.2382688, 36.9123459]).addTo(map);

// Add a popup to the marker
marker.bindPopup("<b>Confluence point!</b><br>Nairobi river.").openPopup();